function [x,xunits,J,Junits,B,Bunits,r,runits]=cs2main(x,c,r,p,xunits,cunits,runits,punits,TIIoption,PIIoption,diagnostics,plotflag);
% [x,xunits,J,Junits,B,Bunits,r,runits]=cs2main(x,c,r,p,xunits,cunits,runits,punits,TIIoption,PIIoption,diagnostics,plotflag);
% cs2main is the master function, which calls module functions and manages
% the data flow within the Communications Satellite Constellation
% Simulator.
% Darren D. Chang (darrenz@mit.edu)
% Olivier de Weck (deweck@mit.edu)
% Last modified: 10/27/03

% 1 cs2main

% Unbundle x Design vector
name        = x.name;           name_n        = size(x.name);
constel     = x.C;              constel_n     = length(x.C);
alti        = x.h;              alti_n        = length(x.h);
elev        = (x.elev)*pi/180;  elev_n        = length(x.elev);
diversity   = x.diversity;      diversity_n   = length(x.diversity);
powerTr     = x.Pt;             powerTr_n     = length(x.Pt);
GT_dB       = x.GT_dB;          GT_dB_n       = length(x.GT_dB);
ISL         = x.ISL;            ISL_n         = length(x.ISL);
MAS         = x.MAS;            MAS_n         = length(x.MAS);
spaceLife   = x.Tsat;           spaceLife_n   = length(x.Tsat);


% Unbundle c Constant vector
MS      = c.MS;
Pe      = c.Pe;
Ge_dB   = c.Ge_dB;
Discount= c.DR;
IDTime  = c.IDT;
ROF     = c.ROF;
clusterSize = c.ClusterSize;
NUIF = c.NUIF;
AKM     = c.AKM;
AKMIsp     = c.AKMIsp;
StationIsp = c.StationIsp;
Risl    = c.Risl;
Rc      = c.Rc;
K       = c.K;
nogoprocreft = c.nogoprocreft;

% Unbundle r Requirements vector
BER=r.BER;
R=r.R;
margin_dB=r.margin_dB;

% Unbundle p Policy vector
Fms_uplink_lb=p.Fms_uplink_lb;
Fms_uplink_ub=p.Fms_uplink_ub;
Fms_downlink_lb=p.Fms_downlink_lb;
Fms_downlink_ub=p.Fms_downlink_ub;
totBW_uplink = Fms_uplink_ub - Fms_uplink_lb;       % [MHz]
totBW_downlink = Fms_downlink_ub - Fms_downlink_lb; % [MHz]
freq = (Fms_downlink_lb+Fms_downlink_ub)/2;         % [MHz]
launchprohibit=p.launchprohibit;
nogateways=p.nogateways;

% check if the gain is so large that it requires LDR

DSatT = 3;
wavelength = 3e8/(freq*1e6);        % [m]
GTmax = (DSatT/wavelength*pi)^2;
GTmax_dB = 10*log10(GTmax);

while GT_dB > GTmax_dB
    disp('The antenna gain you spedified is too large.');
    fprintf('The suggested upper limit is %2.2f \n',GTmax_dB');
    disp('Please give new values for the gain');
    GT_dBlo = input('GT_dB lower bound: ');
    GT_dBup = input('GT_dB upper bound: ');
    GT_dBin = input('GT_dB interval value: ');
    GT_dB = [GT_dBlo:GT_dBin:GT_dBup];
end;
GT_dB_n = length(GT_dB);

%wait bar
%h=waitbar(0,'LEO Design Space Exploration');

% start the full factorial loop
for constel_i = 1:constel_n
    for alti_i = 1:alti_n
        for elev_i = 1:elev_n
            for diversity_i = 1:diversity_n
                for powerTr_i = 1:powerTr_n
                    for GT_dB_i = 1:GT_dB_n
                        for ISL_i = 1:ISL_n
                            for MAS_i = 1:MAS_n
                                for spaceLife_i = 1:spaceLife_n
                                        %display('****************');
                                        result_count = (constel_i-1)*alti_n*elev_n*diversity_n*powerTr_n*GT_dB_n*ISL_n*MAS_n*...
                                            spaceLife_n + (alti_i-1)*elev_n*diversity_n*powerTr_n*GT_dB_n*ISL_n*MAS_n*...
                                            spaceLife_n + (elev_i-1)*diversity_n*powerTr_n*GT_dB_n*ISL_n*MAS_n*...
                                           spaceLife_n + (diversity_i-1)*powerTr_n*GT_dB_n*ISL_n*MAS_n*spaceLife_n...
                                           + (powerTr_i-1)*GT_dB_n*ISL_n*MAS_n*spaceLife_n + (GT_dB_i-1)*ISL_n*MAS_n*...
                                           spaceLife_n + (ISL_i-1)*MAS_n*spaceLife_n + (MAS_i-1)*spaceLife_n + spaceLife_i;
                                        total_runs = constel_n*alti_n*elev_n*diversity_n*powerTr_n*GT_dB_n*ISL_n*MAS_n*spaceLife_n;
                                        %waitbar(result_count/total_runs,h);
                                        fprintf('Progress: %6.0f/%6.0f runs\n',result_count,total_runs)
                                       
% r Requirements adjustment - to account for MAS scheme chosen
if (MAS(MAS_i) == 1) & (1 <= diversity(diversity_i)) & (diversity(diversity_i) < 2)    
    % MF-TDMA single to double coverage
    r.BER(result_count) = 1e-3;         % bit-error-rate
    r.Ruser(result_count) = 4.6;        % duplex channel rate at kbps
    r.margin_dB(result_count) = 16;     % link margin at dB
elseif (MAS(MAS_i) == 1) & (2 <= diversity(diversity_i)) & (diversity(diversity_i) < 3)  
    % MF-TDMA double to triple coverage
    r.BER(result_count) = 1e-3;         
    r.Ruser(result_count) = 4.6;        
    r.margin_dB(result_count) = 10;     
elseif (MAS(MAS_i) == 1) & (3 <= diversity(diversity_i)) & (diversity(diversity_i) <= 4)  
    % MF-TDMA triple to quadrable coverage
    r.BER(result_count) = 1e-3;         
    r.Ruser(result_count) = 4.6;        
    r.margin_dB(result_count) = 4;     
elseif (MAS(MAS_i) == 2) & (1 <= diversity(diversity_i)) & (diversity(diversity_i) < 2)    
    % MF-CDMA single to double coverage
    r.BER(result_count) = 1e-2;         
    r.Ruser(result_count) = 2.4;        
    r.margin_dB(result_count) = 12;     
elseif (MAS(MAS_i) == 2) & (2 <= diversity(diversity_i)) & (diversity(diversity_i) < 3)    
    % MF-CDMA double to triple coverage
    r.BER(result_count) = 1e-2;         
    r.Ruser(result_count) = 2.4;        
    r.margin_dB(result_count) = 6;
elseif (MAS(MAS_i) == 2) & (3 <= diversity(diversity_i)) & (diversity(diversity_i) <= 4)    
    % MF-CDMA triple to quadrable coverage
    r.BER(result_count) = 1e-2;         
    r.Ruser(result_count) = 2.4;        
    r.margin_dB(result_count) = 3;
end;

BER     = r.BER(result_count);
Ruser   = r.Ruser(result_count);
margin_dB = r.margin_dB(result_count);

                                        
                                       
                                        if constel(constel_i) == 1 % polar constellation
                                            PolarOverlappingFactor = 0.68;
										elseif constel(constel_i) == 2 % Walker constellation
                                            PolarOverlappingFactor = 1;
										end;
                                        
                                        % technology infusion interface 1
                                        [addSCMass,addChannelFactor,addDVCost,addFUCost,newTech,ISL(ISL_i),Risl,GT_dB]=...
                                            TechnologyInfusionInterface1(ISL(ISL_i),freq,GT_dB,Risl,TIIoption);
                                        % 2 constellation
                                        [incli,Nmin,NPmin,beamwidthT,cellNumber,Dedge,period,cellDuration,...
                                            DSatT,Afoot,wavelength] = constellation(constel(constel_i),alti(alti_i),elev(elev_i),...
                                            diversity(diversity_i),GT_dB(GT_dB_i),freq);
                                        % technology infusion interface 2
                                        [addSCMass,addChannelFactor,addDVCost,addFUCost,newTech,beamManage]=...
                                            TechnologyInfusionInterface2(TIIoption,GT_dB(GT_dB_i),cellDuration,cellNumber,DSatT,...
                                            totBW_downlink,wavelength,addSCMass,addChannelFactor,addDVCost,...
                                            addFUCost,newTech);
                                        % 3 satellite network
                                        [GWKLOC,NGW,personnel] = satellitenetwork(constel(constel_i),ISL(ISL_i),Nmin,...
                                            NPmin,Afoot);
                                        
                                        % 4 link budget
                                       
                                        
                                            [userPerSat]=linkbudget(MAS,MAS_i,powerTr,powerTr_i,cellNumber,freq,GT_dB,...
                                             GT_dB_i,Ge_dB,Dedge,BER,margin_dB,MS,Rc,K,totBW_downlink,clusterSize,ROF, ...
                                             Ruser,addChannelFactor, ISL, ISL_i, Risl, Nmin, NPmin, NUIF); 
                                      
                                            systemCapacity = floor(userPerSat*Nmin*PolarOverlappingFactor);
                                        
                                        % 5 spacecraft
                                        [Msat,Minsertion,AntW,CEW,SCBDW,BLP,AKMDW,AKMImpulse,FSKLOC] = ...
                                            spacecraft(powerTr(powerTr_i),ISL(ISL_i),GWKLOC,AKMIsp,StationIsp,alti(alti_i),...
                                            spaceLife(spaceLife_i),Risl,addSCMass,DSatT);
                                        
                                        % 6 launch 
                                        [launchVehicle,LVModelFileName,satPerVehicle,numberOfLaunch,launchSite,...
                                                LPModelFileName,LSla,...
                                            LSlo,LSR,minLaunchCost,LScounter,costPerLaunchl,costPerLaunchh,burnoutVelocity] = ...
                                            launch(Msat+Minsertion,incli,alti(alti_i),Nmin,PIIoption);
                                        
                                        if LScounter == 0 | beamManage == 0
                                            if LScounter == 0   % no LV is capable of the launch
                                                disp(strcat('No launch vehicle available for design #',num2str(result_count)));
                                            elseif beamManage == 0
                                                disp(strcat('DBF/ABF needed but not available for design #',num2str(result_count)));
                                            end;
                                            userPerSat = 0;
                                        end
                                        
                                        
                                        % 7 cost
                                        totalCost = ...
                                            cost(Nmin,NPmin,alti(alti_i),AntW,CEW,SCBDW,Msat+Minsertion,BLP,FSKLOC,GWKLOC,...
                                            spaceLife(spaceLife_i),IDTime,NGW,personnel,AKM,AKMDW,AKMImpulse,Discount,...
                                            minLaunchCost,Risl,ISL(ISL_i),addDVCost,addFUCost);
                                        
                                        % 8 market 
                                        [totalAirTime,totalDataFlow,avgSubscriberPerYear] = market(userPerSat,Nmin,Afoot,...
                                            IDTime,spaceLife(spaceLife_i),Ruser);

                                        % save results (repack output structures)
    
                                        % objective vector
                                        J.totalcap(result_count)=systemCapacity;                              %[simultaneous users]
                                        J.lifecyclecost(result_count)=totalCost/1e6;                          %[B$ 2002]
                                        J.subscriberPerYear(result_count)=avgSubscriberPerYear;               %[number of subscribers]
                                        J.totalAirTime(result_count)=totalAirTime;                            %[min]
                                        J.totalDataFlow(result_count)=totalDataFlow/1000;                     %[GB]
                                        J.costPerFunction(result_count)=totalCost*1e3/(totalDataFlow/1000);   %[$/GB]
    
                                        Junits.totalcap='[simultaneous users]';
                                        Junits.lifecyclecost='[B$ 2002]';
                                        Junits.subscriberPerYear='[subscribers per year]';
                                        Junits.totalAirTime='[minutes]';
                                        Junits.totalDataFlow='[GB]';
                                        Junits.costPerFunction='[$/GB]';
    
                                        % benchmark variables (useful to compare with other systems)
    
                                        B.Number_of_Satellites(result_count)=Nmin;
                                        B.Number_of_Orbital_Planes(result_count)=NPmin;
                                        B.Orbital_Altitude(result_count)=alti(alti_i);
                                        B.Orbital_Period(result_count)=period;
                                        B.Transmitter_Gain(result_count)=GT_dB(GT_dB_i);
                                        B.Transmitter_Power(result_count)=powerTr(powerTr_i);
                                        B.Satellite_Space_Life(result_count)=spaceLife(spaceLife_i);
                                        B.SatelliteUserLink_Frequency(result_count)=freq/1000;
                                        B.SatelliteUserLink_Bandwidth(result_count)=totBW_downlink;
                                        B.Average_EIRP(result_count)=GT_dB(GT_dB_i)+10*log10(powerTr(powerTr_i));
                                        B.Power_Flux_Density(result_count)=powerTr(powerTr_i)/(Dedge*1000)^2/4/pi;
                                        B.HalfAngle_Beamwidth(result_count)=beamwidthT;
                                        B.Channel_Datarate(result_count)=Ruser;
                                        B.Modulation_Scheme{result_count}=MS;
                                        B.Transmitter_Dimension(result_count)=DSatT;
                                        B.Footprint_Area(result_count)=Afoot;
                                        B.Number_of_Cells(result_count)=cellNumber;
                                        B.User_Duration_in_Cell(result_count)=cellDuration;
                                        B.Satellite_Capacity(result_count)=userPerSat;
                                        B.Number_of_Gateways(result_count)=NGW;
                                        B.Satellite_Mass(result_count)=Msat;
                                        B.Launch_Vehicle(result_count)=launchVehicle;
                                        B.Satellites_per_Vehicle(result_count)=satPerVehicle;
                                        B.Number_of_Launch(result_count)=numberOfLaunch;
                                        B.NewTechAdopted{result_count}=newTech;
    
                                        Bunits.Number_of_Satellites='[# of sats]';
                                        Bunits.Number_of_Orbital_Planes='[# of planes]';
                                        Bunits.Orbital_Altitude='[km]';
                                        Bunits.Orbital_Period='[min]';
                                        Bunits.Transmitter_Gain='[dBi]';
                                        Bunits.Transmitter_Power='[W]';
                                        Bunits.Satellite_Space_Life='[year]';
                                        Bunits.SatelliteUserLink_Frequency='[GHz]';
                                        Bunits.SatelliteUserLink_Bandwidth='[MHz]';
                                        Bunits.Average_EIRP='[dBW]';
                                        Bunits.Power_Flux_Density='[Jy]';
                                        Bunits.HalfAngle_Beamwidth='[deg]';
                                        Bunits.Channel_Datarate='[kbps]';
                                        Bunits.Modulation_Scheme='[modulation]';
                                        Bunits.Transmitter_Dimension='[m]';
                                        Bunits.Footprint_Area='[km^2]';
                                        Bunits.Number_of_Cells='[-]';
                                        Bunits.User_Duration_in_Cell='[sec]';
                                        Bunits.Satellite_Capacity='[# voice circuits per sat]';
                                        Bunits.Number_of_Gateways='[# ground stations]';
                                        Bunits.Satellite_Mass='[kg]';
                                        Bunits.Launch_Vehicle='[type of launch vehicle]';
                                        Bunits.Satellites_per_Vehicle='[number of satellits per launch vehicle]';
                                        Bunits.NewTechAdopted='[list of new technology adopted]';
                                        
                                        X.constel(result_count)     = constel(constel_i);
                                        X.alti(result_count)        = alti(alti_i);
                                        X.elev(result_count)        = elev(elev_i);
                                        X.diversity(result_count)   = diversity(diversity_i);
                                        X.powerTr(result_count)     = powerTr(powerTr_i);
                                        X.GT_dB(result_count)       = GT_dB(GT_dB_i);
                                        X.ISL(result_count)         = ISL(ISL_i);
                                        X.MAS(result_count)         = MAS(MAS_i);
                                        X.spaceLife(result_count)   = spaceLife(spaceLife_i);
                                        
                                        P.Fms_uplink_lb(result_count)=p.Fms_uplink_lb;
                                        P.Fms_uplink_ub(result_count)=p.Fms_uplink_ub;
                                        P.Fms_downlink_lb(result_count)=p.Fms_downlink_lb;
                                        P.Fms_downlink_ub(result_count)=p.Fms_downlink_ub;
                                end;
                            end;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;

% end cs2main.m
